﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="MyTasks.aspx.cs" Inherits="VIRP_WEB.Help.MyTasks" %>
<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" runat="server">
   <style>
        SPAN.searchword {
            background-color: yellow;
        }

        table tr {
            vertical-align: top;
        }

        table th {
            text-align: left;
        }

        img.HelpImage {
            border: solid 2px white;
            margin-left: 0.5in;
        }

        div.SectionDivider {
            padding-left: 0.5in;
            padding-bottom: .25in;
        }
    </style>
    <script src="../Scripts/TextHighlite.js" type="text/javascript"></script>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" runat="server">
        <h2 class="western">Browsing a Registry</h2>
        <div class="SectionDivider">
            <p>The Registry framework allows any user in the VA active directory to access the VIRP Registry framework.  The process to login to the VIRP Registry framework is given in the flow diagram below.    </p>
            <img class="HelpImage"src="images/UserGuide3_html_m7106a9ea.png" width="568" height="671">
            <p>A brief overview of the features of Registry Framewotk is listed as a flow diagram below.     </p>
            <img class="HelpImage"src="images/UserGuide3_html_390d446f.png" width="590" height="833">
            <p>The VIRP home page is displayed with a list of &lsquo;Available Registries&rsquo; and &lsquo;Your Registries&rsquo;. If the user has access to any of the Registries with a role, the Registry for which access has been granted by the Administrator will display under &lsquo;Your Registries&rsquo;.  The other Registries will display under &lsquo;Available Registries&rsquo;.      </p>
            <p>Depending on the role of the user, he can be a Administrator, Update, Read or None.  For a User with None access, he can only see the Registries under &lsquo;Available Registries&rsquo;. The Read user can only search, view data and have access to the reports. The Update user will have the permission to Update data in the Registry along with all the Read privileges. The Administrator will have access to the Administration menu items along with all privileges of Update and Read.       </p>
            <p>A user with access to the registry can view the Registry information, Patients and Referrals.      </p>
            <h3 class="western">1.Adding patients to a Registry</h3>
            <div class="SectionDivider">
                <p>The Patients are added to the Registry automatically by the scheduled ETLs based on the Cohort Criteria defined at the time of creating a Registry.  The Patient data is imported into the Registry from CDW or other administrative datasets. For each Patient added to the Registry a Referral is created in the Registry.  Framework data associated with the patient is also imported into the Registry database.  An user can also add a Patient to the Registry by searching for a patient in the VIRP database.        </p>
            </div>
            <h3 class="western">2.Referrals in the Registry</h3>
            <div class="SectionDivider">
                <p>The Referral in a Registry is the link to a Patient in the Registry.  To access the Referrals in a Registry, select the Registry from the list of &lsquo;Your Registries&rsquo; and a Referrals view is displayed.  The user can select the &lsquo;Referrals&rsquo; menu item from the left hand menu items to get to the Referrals view page at any time.    </p>
                <img class="HelpImage"src="images/UserGuide3_html_369beff8.png" width="626" height="239">
                <p>The user can either search for a Patient and the select or select the Patient from the Referral view to view the details of the Patient.  The Referral view also list of Framework data tables in a tab view which gives access to the user to view the Framework data of the patient.    </p>
                <p>A flow diagram for the Referral view is given below.</p>
                <img class="HelpImage"src="images/UserGuide3_html_m6eb6171f.png" width="540" height="753">
                <p>Referral View</p>
                <img class="HelpImage"src="images/UserGuide3_html_33e9c1e0.png" width="547" height="258">
            </div>
            <h3 class="western">3.Patient drill down</h3>
            <div class="SectionDivider">
                <p>The Patient menu allows the user to access the patients in the Registry.  User can get to the Patients page by selecting the Patients menu item from the left hand menu item of the page. The Patients view page displays the Patient details and allows you &lsquo;Add New Patient&rsquo; to the Registry.    </p>
                <p>Patients View</p>
                <img class="HelpImage"src="images/UserGuide3_html_m6c36989b.png" width="624" height="149">
                <p>Selecting a Patient by selecting the &lsquo;Patient ID&rsquo; displays the Patient details along with a list of Registries that the Patient is associated with.    </p>
                <p>A user with Update access can &lsquo;Edit Patient&rsquo; and update the patient details.    </p>
                <p>Selecting the &lsquo;Referral ID&rsquo; from the Patients view or &lsquo;Select&rsquo; from the Patient view will display the Referral View for the Patient.    </p>
                <p>Patient View</p>
                <img class="HelpImage"src="images/UserGuide3_html_m7edccda8.png" width="615" height="279">
                <p>An overview of the Patient drill down is illustrated in a flow diagram below.    </p>
                <img class="HelpImage"src="images/UserGuide3_html_53f0a5f3.png" width="591" height="819">
            </div>
            <h3 class="western">4.Work Stream</h3>
            <div class="SectionDivider">
                <p>The VIRP framework has a Work Stream functionality built in whih allows the user to initiate a activity based work flow for each patient in the Registry.  The Work Streams defined can be automatically added to the Patient at the time they are added to the Registry if the Work Stream has been configured to automatically start.    </p>
                <p>A brief overview of the Work Stream functionality is illustrated as a flow diagram below.   </p>
                <img class="HelpImage"src="images/UserGuide3_html_38a34477.png" width="598" height="583">
                <p>Work Streams can be accessed by selecting &lsquo;Work Stream&rsquo; from the left menu item.  All Work Streams details associated with the Patients in the Registry are displayed along with the Status.    </p>
                <p>Work Streams View</p>
                <img class="HelpImage"src="images/UserGuide3_html_m1eecf4ca.png" width="623" height="220">
                <p>The user can Edit, Delete or View the Work Stream details.</p>
                <p>Edit View</p>
                <img class="HelpImage"src="images/UserGuide3_html_a0ca60.png" width="452" height="222">
                <p>Work Stream details view</p>
                <img class="HelpImage"src="images/UserGuide3_html_m5865d633.png" width="575" height="283">
                <p>The user can update the status of the Work Stream from the details view.  The details view also displays the list of activities associated with the Work Stream along with the status of each activity.  Selecting an activity from the details view displays the activity details.    </p>
            </div>
            <h3 class="western">5.Activities</h3>
            <div class="SectionDivider">
                <p>An Activity in the VIRP Registry framework is a step or process associated with a Work Stream.  All Activities associated with the Work Stream get created if they have been configured to automatically get created when a Work Stream is added.    </p>
                <p>A brief overview of Activities is explained with a flow diagram below.    </p>
                <img class="HelpImage"src="images/UserGuide3_html_m53a22071.png" width="623" height="602">
                <p>The Activities in the Registry can be accessed from the Activities view.  Select the Activities menu item from the left hand menu items to view the list of Activities in the Registry.    </p>
                <p>Activities View</p>
                <img class="HelpImage"src="images/UserGuide3_html_62dd0126.png" width="623" height="254">
                <p>The The user can Select(view the details), Edit or Delete the Activity.    </p>
                <p>Activity &ndash; details view</p>
                <img class="HelpImage"src="images/UserGuide3_html_14d2857b.png" width="624" height="335">
                <p>The user can change the status of the Activity by clicking on any of the status buttons.    </p>
                <p>The user can change the details of the Activity by selecting &lsquo;Edit&rsquo; from the Activities View or selecting &lsquo;Edit Activity&rsquo; in the Activity &ndash; details view.     </p>
                <p>The &lsquo;Add New Activity&rsquo; allowd the user to add a new activity for a Patient in the Registry.    </p>
                <p>The Edit / Add activity displays the &lsquo;Add / Edit Activity View&rsquo; and the user can update the details for the activity and click on &lsquo;Save&rsquo; to save the Activity details.    </p>
                <p>Add / Edit Activity View</p>
                <img class="HelpImage"src="images/UserGuide3_html_m4cbf09d9.png" width="488" height="572">
            </div>
            <h3 class="western">6.Surveys</h3>
            <div class="SectionDivider">
                <p>Surveys are a set of questions defined for the Registry.  Each Survey in the Registry will have a set of questions wherein some of the questions can have predefined choice answers.  If a question in a Survey does not a predefined choice answer, it will take a free text answer when the Registry user completes the Survey for a Patient.    </p>
                <p>A brief overview of the Survey functionality is illustrated in the flow diagram below.    </p>
                <img class="HelpImage"src="images/UserGuide3_html_1aca0b93.png" width="618" height="601">
                <p>The list of Surveys in the Registry can be accessed by selecting the &lsquo;Surveys&rsquo; from the left menu items of the Registry home page  </p>
                <p>Survey &ndash; details view</p>
                <img class="HelpImage"src="images/UserGuide3_html_m927daa0.png" width="627" height="181">
                <p>The user can Edit, Delete, Select or Add New Survey from the Survey &ndash; details view.</p>
                <p>Edit Survey / Add New Survey</p>
                <img class="HelpImage"src="images/UserGuide3_html_m34e6fa64.png" width="443" height="139">
                <p>Select &ndash; survey view, complete and save</p>
                <img class="HelpImage"src="images/UserGuide3_html_m4f3843df.png" width="271" height="601">
            </div>
            <h3 class="western">7.User Defined Fields</h3>
            <div class="SectionDivider">
                <p>VIRP Registry framework provides for upto 10 User Defined Fields per Registry.  These fields once configured by the Registry Administrator can be used to capture additional data for a Patient in the Registry. </p>
                <p>A brief overview of the User Defined Fields functionality is illustrated by the flow diagram below.    </p>
                <img class="HelpImage"src="images/UserGuide3_html_5d581246.png" width="367" height="601">
                <p>The User Defined Fields can be accessed from the left hand menu item &lsquo;User Defined Fields&rsquo;.    </p>
                <p>If a Patient or Referral is not selected, the user is asked to select a Patient or Referral before viewing the User Defined Fields. The User Defined Fields view allows the user to enter or edit values for the fields and save the information.     </p>
                <p>User Defined Fields &ndash; View</p>
                <img class="HelpImage"src="images/UserGuide3_html_129e6772.png" width="394" height="333">
            </div>
        </div>
</asp:Content>
